const char MAX_UDP_SOCKET_BUFFERS = 4;
const char MAX_TCP_SOCKET_BUFFERS = 0;
const unsigned UDP_BUF_SIZE= 4096;
const unsigned TCP_BUF_SIZE= 0;
const char MAX_SOCKETS = 3;
#include <stcpip.h>

// undefine this if you don't want dhcp

// if you use hardcoded addresses
// edit these defines
//
// remember to add udpdebug.lib to your lib.dir in the compiler directory!
//
#include "UDPDebug.h"

typedef struct {
	float random;
	long int counter;
	char string[80];
	int edit_me;
} demostruct;

//
// this define tells the debugger to stop looking for stucture,
// typedef, enums and #defines. It can't handle 'c' code, only
// what would normally be in a ".h" file.
//
#define NO_DEBUG_PARSE

demostruct demo;
int count;

void near mytick()
{
	static char slow=0;
	tcp_tick(NULL);
	if (++slow==4)
	{
		debug_tick();
		slow=0;
	}
}

#define SIZE 8190
#define FALSE 0
#define TRUE 1

void sievetest(int reps)
{
	int i,j,k,count,prime;
	static char flag[SIZE+1];
    for (i=0;i<reps;i++)
	{
		count=0;
		for (j=0; j<=SIZE; j++) flag[j]=TRUE;

		for (j=0; j<=SIZE; j++)
			{if(flag[j])
				{
				prime=2*j+3;
				for(k=j+prime; k<= SIZE; k+=prime)
					flag[k]=FALSE; /*discard multiples*/
				count++;
			}
		}
	}
}

void main(void)
{
	unsigned long stime,etime;
	WDT_DISABLE();
	ipset0();
// disable by default, otherwise any printfs will hang if they happen before
// sock_init()/debug_init(1)
	demo.counter=0l;
	demo.edit_me=count=0;
    startTimer(20,0,1);
	//	Select ethernet hardware: usingAsix, usingDevKit, usingRealtek, usingSMSC
	printf("Network startup\n");
	usingAll();
	sock_init();
	printf("IP=%lx\n",gethostid());
	timerSetHandler(mytick);
// everything ready now enable the debugger
	debug_init(1);
	_stdio=debug_stdio;
	printf("Ready to debug!\n");
	while(1)
	{
		// poll this from time to time......
		//
		stime=MS_TIMER;
		sievetest(10);
		etime=MS_TIMER-stime;
		printf("Sieve test time/loop: %d.%d ms\n",((unsigned)etime)/10,((unsigned)etime)%10);
		demo.counter++;
		demo.random=rand()+((float)rand()/(float)(RAND_MAX));
		sprintf(demo.string,"Count is now %d, demo.random=%f\n",++count,demo.random);
	}
}
